package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListNotificationRulesResponse(
    nextToken: Option[NextToken] = None,
    notificationRules: Option[
      Iterable[zio.aws.codestarnotifications.model.NotificationRuleSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse = {
    import ListNotificationRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        notificationRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notificationRules)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.ListNotificationRulesResponse.ReadOnly =
    zio.aws.codestarnotifications.model.ListNotificationRulesResponse
      .wrap(buildAwsValue())
}
object ListNotificationRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.ListNotificationRulesResponse =
      zio.aws.codestarnotifications.model.ListNotificationRulesResponse(
        nextToken.map(value => value),
        notificationRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def notificationRules: Option[
      List[zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNotificationRules: ZIO[Any, AwsError, List[
      zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("notificationRules", notificationRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse
  ) extends zio.aws.codestarnotifications.model.ListNotificationRulesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.NextToken(value)
      )
    override val notificationRules: Option[
      List[zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly]
    ] = scala
      .Option(impl.notificationRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarnotifications.model.NotificationRuleSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse
  ): zio.aws.codestarnotifications.model.ListNotificationRulesResponse.ReadOnly =
    new Wrapper(impl)
}
