package zio.aws.codestarnotifications.model
import java.lang.Integer
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTargetsRequest(
    filters: Option[
      Iterable[zio.aws.codestarnotifications.model.ListTargetsFilter]
    ] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest = {
    import ListTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.ListTargetsRequest.ReadOnly =
    zio.aws.codestarnotifications.model.ListTargetsRequest.wrap(buildAwsValue())
}
object ListTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.ListTargetsRequest =
      zio.aws.codestarnotifications.model.ListTargetsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[
      List[zio.aws.codestarnotifications.model.ListTargetsFilter.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.codestarnotifications.model.ListTargetsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest
  ) extends zio.aws.codestarnotifications.model.ListTargetsRequest.ReadOnly {
    override val filters: Option[
      List[zio.aws.codestarnotifications.model.ListTargetsFilter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarnotifications.model.ListTargetsFilter.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.NextToken(value)
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest
  ): zio.aws.codestarnotifications.model.ListTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
