package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.NotificationRuleArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteNotificationRuleRequest(arn: NotificationRuleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleRequest = {
    import DeleteNotificationRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleRequest
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.DeleteNotificationRuleRequest.ReadOnly =
    zio.aws.codestarnotifications.model.DeleteNotificationRuleRequest
      .wrap(buildAwsValue())
}
object DeleteNotificationRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.DeleteNotificationRuleRequest =
      zio.aws.codestarnotifications.model.DeleteNotificationRuleRequest(arn)
    def arn: NotificationRuleArn
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleRequest
  ) extends zio.aws.codestarnotifications.model.DeleteNotificationRuleRequest.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleRequest
  ): zio.aws.codestarnotifications.model.DeleteNotificationRuleRequest.ReadOnly =
    new Wrapper(impl)
}
