package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  TargetAddress,
  TargetType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Target(
    targetType: Option[TargetType] = None,
    targetAddress: Option[TargetAddress] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.Target = {
    import Target.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.Target
      .builder()
      .optionallyWith(
        targetType.map(value => TargetType.unwrap(value): java.lang.String)
      )(_.targetType)
      .optionallyWith(
        targetAddress.map(value =>
          TargetAddress.unwrap(value): java.lang.String
        )
      )(_.targetAddress)
      .build()
  }
  def asReadOnly: zio.aws.codestarnotifications.model.Target.ReadOnly =
    zio.aws.codestarnotifications.model.Target.wrap(buildAwsValue())
}
object Target {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.Target
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.Target =
      zio.aws.codestarnotifications.model.Target(
        targetType.map(value => value),
        targetAddress.map(value => value)
      )
    def targetType: Option[TargetType]
    def targetAddress: Option[TargetAddress]
    def getTargetType: ZIO[Any, AwsError, TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getTargetAddress: ZIO[Any, AwsError, TargetAddress] =
      AwsError.unwrapOptionField("targetAddress", targetAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.Target
  ) extends zio.aws.codestarnotifications.model.Target.ReadOnly {
    override val targetType: Option[TargetType] = scala
      .Option(impl.targetType())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.TargetType(value)
      )
    override val targetAddress: Option[TargetAddress] = scala
      .Option(impl.targetAddress())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.TargetAddress(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.Target
  ): zio.aws.codestarnotifications.model.Target.ReadOnly = new Wrapper(impl)
}
