package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEventTypesResponse(
    eventTypes: Option[
      Iterable[zio.aws.codestarnotifications.model.EventTypeSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse = {
    import ListEventTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse
      .builder()
      .optionallyWith(
        eventTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventTypes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.ListEventTypesResponse.ReadOnly =
    zio.aws.codestarnotifications.model.ListEventTypesResponse
      .wrap(buildAwsValue())
}
object ListEventTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.ListEventTypesResponse =
      zio.aws.codestarnotifications.model.ListEventTypesResponse(
        eventTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventTypes: Option[
      List[zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getEventTypes: ZIO[Any, AwsError, List[
      zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("eventTypes", eventTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse
  ) extends zio.aws.codestarnotifications.model.ListEventTypesResponse.ReadOnly {
    override val eventTypes: Option[
      List[zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly]
    ] = scala
      .Option(impl.eventTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarnotifications.model.EventTypeSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse
  ): zio.aws.codestarnotifications.model.ListEventTypesResponse.ReadOnly =
    new Wrapper(impl)
}
