package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  EventTypeId,
  NotificationRuleName,
  NotificationRuleArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateNotificationRuleRequest(
    arn: NotificationRuleArn,
    name: Option[NotificationRuleName] = None,
    status: Option[zio.aws.codestarnotifications.model.NotificationRuleStatus] =
      None,
    eventTypeIds: Option[Iterable[EventTypeId]] = None,
    targets: Option[Iterable[zio.aws.codestarnotifications.model.Target]] =
      None,
    detailType: Option[zio.aws.codestarnotifications.model.DetailType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.UpdateNotificationRuleRequest = {
    import UpdateNotificationRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.UpdateNotificationRuleRequest
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        name.map(value => NotificationRuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        eventTypeIds.map(value =>
          value.map { item =>
            EventTypeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.eventTypeIds)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(detailType.map(value => value.unwrap))(_.detailType)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.UpdateNotificationRuleRequest.ReadOnly =
    zio.aws.codestarnotifications.model.UpdateNotificationRuleRequest
      .wrap(buildAwsValue())
}
object UpdateNotificationRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.UpdateNotificationRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.UpdateNotificationRuleRequest =
      zio.aws.codestarnotifications.model.UpdateNotificationRuleRequest(
        arn,
        name.map(value => value),
        status.map(value => value),
        eventTypeIds.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        detailType.map(value => value)
      )
    def arn: NotificationRuleArn
    def name: Option[NotificationRuleName]
    def status
        : Option[zio.aws.codestarnotifications.model.NotificationRuleStatus]
    def eventTypeIds: Option[List[EventTypeId]]
    def targets
        : Option[List[zio.aws.codestarnotifications.model.Target.ReadOnly]]
    def detailType: Option[zio.aws.codestarnotifications.model.DetailType]
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, NotificationRuleName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codestarnotifications.model.NotificationRuleStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getEventTypeIds: ZIO[Any, AwsError, List[EventTypeId]] =
      AwsError.unwrapOptionField("eventTypeIds", eventTypeIds)
    def getTargets: ZIO[Any, AwsError, List[
      zio.aws.codestarnotifications.model.Target.ReadOnly
    ]] = AwsError.unwrapOptionField("targets", targets)
    def getDetailType
        : ZIO[Any, AwsError, zio.aws.codestarnotifications.model.DetailType] =
      AwsError.unwrapOptionField("detailType", detailType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.UpdateNotificationRuleRequest
  ) extends zio.aws.codestarnotifications.model.UpdateNotificationRuleRequest.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
    override val name: Option[NotificationRuleName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .NotificationRuleName(value)
      )
    override val status
        : Option[zio.aws.codestarnotifications.model.NotificationRuleStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.codestarnotifications.model.NotificationRuleStatus.wrap(value)
        )
    override val eventTypeIds: Option[List[EventTypeId]] = scala
      .Option(impl.eventTypeIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarnotifications.model.primitives.EventTypeId(item)
        }.toList
      )
    override val targets
        : Option[List[zio.aws.codestarnotifications.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codestarnotifications.model.Target.wrap(item)
          }.toList
        )
    override val detailType
        : Option[zio.aws.codestarnotifications.model.DetailType] = scala
      .Option(impl.detailType())
      .map(value => zio.aws.codestarnotifications.model.DetailType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.UpdateNotificationRuleRequest
  ): zio.aws.codestarnotifications.model.UpdateNotificationRuleRequest.ReadOnly =
    new Wrapper(impl)
}
