package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  NotificationRuleArn,
  NotificationRuleId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NotificationRuleSummary(
    id: Option[NotificationRuleId] = None,
    arn: Option[NotificationRuleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary = {
    import NotificationRuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary
      .builder()
      .optionallyWith(
        id.map(value => NotificationRuleId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => NotificationRuleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly =
    zio.aws.codestarnotifications.model.NotificationRuleSummary
      .wrap(buildAwsValue())
}
object NotificationRuleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.NotificationRuleSummary =
      zio.aws.codestarnotifications.model.NotificationRuleSummary(
        id.map(value => value),
        arn.map(value => value)
      )
    def id: Option[NotificationRuleId]
    def arn: Option[NotificationRuleArn]
    def getId: ZIO[Any, AwsError, NotificationRuleId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, NotificationRuleArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary
  ) extends zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly {
    override val id: Option[NotificationRuleId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.NotificationRuleId(value)
      )
    override val arn: Option[NotificationRuleArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .NotificationRuleArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary
  ): zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly =
    new Wrapper(impl)
}
