package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  NotificationRuleResource,
  TagValue,
  CreatedTimestamp,
  NotificationRuleCreatedBy,
  NotificationRuleName,
  LastModifiedTimestamp,
  NotificationRuleArn,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeNotificationRuleResponse(
    arn: NotificationRuleArn,
    name: Option[NotificationRuleName] = None,
    eventTypes: Option[
      Iterable[zio.aws.codestarnotifications.model.EventTypeSummary]
    ] = None,
    resource: Option[NotificationRuleResource] = None,
    targets: Option[
      Iterable[zio.aws.codestarnotifications.model.TargetSummary]
    ] = None,
    detailType: Option[zio.aws.codestarnotifications.model.DetailType] = None,
    createdBy: Option[NotificationRuleCreatedBy] = None,
    status: Option[zio.aws.codestarnotifications.model.NotificationRuleStatus] =
      None,
    createdTimestamp: Option[CreatedTimestamp] = None,
    lastModifiedTimestamp: Option[LastModifiedTimestamp] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse = {
    import DescribeNotificationRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        name.map(value => NotificationRuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        eventTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventTypes)
      .optionallyWith(
        resource.map(value =>
          NotificationRuleResource.unwrap(value): java.lang.String
        )
      )(_.resource)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(detailType.map(value => value.unwrap))(_.detailType)
      .optionallyWith(
        createdBy.map(value =>
          NotificationRuleCreatedBy.unwrap(value): java.lang.String
        )
      )(_.createdBy)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdTimestamp.map(value => CreatedTimestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastModifiedTimestamp.map(value =>
          LastModifiedTimestamp.unwrap(value): Instant
        )
      )(_.lastModifiedTimestamp)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly =
    zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse
      .wrap(buildAwsValue())
}
object DescribeNotificationRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse =
      zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse(
        arn,
        name.map(value => value),
        eventTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resource.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        detailType.map(value => value),
        createdBy.map(value => value),
        status.map(value => value),
        createdTimestamp.map(value => value),
        lastModifiedTimestamp.map(value => value),
        tags.map(value => value)
      )
    def arn: NotificationRuleArn
    def name: Option[NotificationRuleName]
    def eventTypes: Option[
      List[zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly]
    ]
    def resource: Option[NotificationRuleResource]
    def targets: Option[
      List[zio.aws.codestarnotifications.model.TargetSummary.ReadOnly]
    ]
    def detailType: Option[zio.aws.codestarnotifications.model.DetailType]
    def createdBy: Option[NotificationRuleCreatedBy]
    def status
        : Option[zio.aws.codestarnotifications.model.NotificationRuleStatus]
    def createdTimestamp: Option[CreatedTimestamp]
    def lastModifiedTimestamp: Option[LastModifiedTimestamp]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, NotificationRuleName] =
      AwsError.unwrapOptionField("name", name)
    def getEventTypes: ZIO[Any, AwsError, List[
      zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("eventTypes", eventTypes)
    def getResource: ZIO[Any, AwsError, NotificationRuleResource] =
      AwsError.unwrapOptionField("resource", resource)
    def getTargets: ZIO[Any, AwsError, List[
      zio.aws.codestarnotifications.model.TargetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("targets", targets)
    def getDetailType
        : ZIO[Any, AwsError, zio.aws.codestarnotifications.model.DetailType] =
      AwsError.unwrapOptionField("detailType", detailType)
    def getCreatedBy: ZIO[Any, AwsError, NotificationRuleCreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codestarnotifications.model.NotificationRuleStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreatedTimestamp: ZIO[Any, AwsError, CreatedTimestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, LastModifiedTimestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse
  ) extends zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
    override val name: Option[NotificationRuleName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .NotificationRuleName(value)
      )
    override val eventTypes: Option[
      List[zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly]
    ] = scala
      .Option(impl.eventTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarnotifications.model.EventTypeSummary.wrap(item)
        }.toList
      )
    override val resource: Option[NotificationRuleResource] = scala
      .Option(impl.resource())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .NotificationRuleResource(value)
      )
    override val targets: Option[
      List[zio.aws.codestarnotifications.model.TargetSummary.ReadOnly]
    ] = scala
      .Option(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarnotifications.model.TargetSummary.wrap(item)
        }.toList
      )
    override val detailType
        : Option[zio.aws.codestarnotifications.model.DetailType] = scala
      .Option(impl.detailType())
      .map(value => zio.aws.codestarnotifications.model.DetailType.wrap(value))
    override val createdBy: Option[NotificationRuleCreatedBy] = scala
      .Option(impl.createdBy())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .NotificationRuleCreatedBy(value)
      )
    override val status
        : Option[zio.aws.codestarnotifications.model.NotificationRuleStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.codestarnotifications.model.NotificationRuleStatus.wrap(value)
        )
    override val createdTimestamp: Option[CreatedTimestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.CreatedTimestamp(value)
      )
    override val lastModifiedTimestamp: Option[LastModifiedTimestamp] = scala
      .Option(impl.lastModifiedTimestamp())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .LastModifiedTimestamp(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codestarnotifications.model.primitives.TagKey(
              key
            ) -> zio.aws.codestarnotifications.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse
  ): zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly =
    new Wrapper(impl)
}
