package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  ClientRequestToken,
  NotificationRuleArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SubscribeRequest(
    arn: NotificationRuleArn,
    target: zio.aws.codestarnotifications.model.Target,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.SubscribeRequest = {
    import SubscribeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.SubscribeRequest
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .target(target.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.SubscribeRequest.ReadOnly =
    zio.aws.codestarnotifications.model.SubscribeRequest.wrap(buildAwsValue())
}
object SubscribeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.SubscribeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.SubscribeRequest =
      zio.aws.codestarnotifications.model.SubscribeRequest(
        arn,
        target.asEditable,
        clientRequestToken.map(value => value)
      )
    def arn: NotificationRuleArn
    def target: zio.aws.codestarnotifications.model.Target.ReadOnly
    def clientRequestToken: Option[ClientRequestToken]
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
    def getTarget: ZIO[
      Any,
      Nothing,
      zio.aws.codestarnotifications.model.Target.ReadOnly
    ] = ZIO.succeed(target)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.SubscribeRequest
  ) extends zio.aws.codestarnotifications.model.SubscribeRequest.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
    override val target: zio.aws.codestarnotifications.model.Target.ReadOnly =
      zio.aws.codestarnotifications.model.Target.wrap(impl.target())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.SubscribeRequest
  ): zio.aws.codestarnotifications.model.SubscribeRequest.ReadOnly =
    new Wrapper(impl)
}
