package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.ListTargetsFilterValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTargetsFilter(
    name: zio.aws.codestarnotifications.model.ListTargetsFilterName,
    value: ListTargetsFilterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.ListTargetsFilter = {
    import ListTargetsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.ListTargetsFilter
      .builder()
      .name(name.unwrap)
      .value(ListTargetsFilterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.ListTargetsFilter.ReadOnly =
    zio.aws.codestarnotifications.model.ListTargetsFilter.wrap(buildAwsValue())
}
object ListTargetsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.ListTargetsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.ListTargetsFilter =
      zio.aws.codestarnotifications.model.ListTargetsFilter(name, value)
    def name: zio.aws.codestarnotifications.model.ListTargetsFilterName
    def value: ListTargetsFilterValue
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.codestarnotifications.model.ListTargetsFilterName
    ] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, ListTargetsFilterValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListTargetsFilter
  ) extends zio.aws.codestarnotifications.model.ListTargetsFilter.ReadOnly {
    override val name
        : zio.aws.codestarnotifications.model.ListTargetsFilterName =
      zio.aws.codestarnotifications.model.ListTargetsFilterName
        .wrap(impl.name())
    override val value: ListTargetsFilterValue =
      zio.aws.codestarnotifications.model.primitives
        .ListTargetsFilterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListTargetsFilter
  ): zio.aws.codestarnotifications.model.ListTargetsFilter.ReadOnly =
    new Wrapper(impl)
}
