package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.NotificationRuleArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubscribeResponse(
    arn: Optional[NotificationRuleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.SubscribeResponse = {
    import SubscribeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.SubscribeResponse
      .builder()
      .optionallyWith(
        arn.map(value => NotificationRuleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.SubscribeResponse.ReadOnly =
    zio.aws.codestarnotifications.model.SubscribeResponse.wrap(buildAwsValue())
}
object SubscribeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.SubscribeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.SubscribeResponse =
      zio.aws.codestarnotifications.model
        .SubscribeResponse(arn.map(value => value))
    def arn: Optional[NotificationRuleArn]
    def getArn: ZIO[Any, AwsError, NotificationRuleArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.SubscribeResponse
  ) extends zio.aws.codestarnotifications.model.SubscribeResponse.ReadOnly {
    override val arn: Optional[NotificationRuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .NotificationRuleArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.SubscribeResponse
  ): zio.aws.codestarnotifications.model.SubscribeResponse.ReadOnly =
    new Wrapper(impl)
}
