package zio.aws.codestarnotifications.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestarnotifications.model.primitives.{
  NotificationRuleResource,
  TagValue,
  CreatedTimestamp,
  NotificationRuleCreatedBy,
  NotificationRuleName,
  LastModifiedTimestamp,
  NotificationRuleArn,
  TagKey
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeNotificationRuleResponse(
    arn: NotificationRuleArn,
    name: Optional[NotificationRuleName] = Optional.Absent,
    eventTypes: Optional[
      Iterable[zio.aws.codestarnotifications.model.EventTypeSummary]
    ] = Optional.Absent,
    resource: Optional[NotificationRuleResource] = Optional.Absent,
    targets: Optional[
      Iterable[zio.aws.codestarnotifications.model.TargetSummary]
    ] = Optional.Absent,
    detailType: Optional[zio.aws.codestarnotifications.model.DetailType] =
      Optional.Absent,
    createdBy: Optional[NotificationRuleCreatedBy] = Optional.Absent,
    status: Optional[
      zio.aws.codestarnotifications.model.NotificationRuleStatus
    ] = Optional.Absent,
    createdTimestamp: Optional[CreatedTimestamp] = Optional.Absent,
    lastModifiedTimestamp: Optional[LastModifiedTimestamp] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse = {
    import DescribeNotificationRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        name.map(value => NotificationRuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        eventTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventTypes)
      .optionallyWith(
        resource.map(value =>
          NotificationRuleResource.unwrap(value): java.lang.String
        )
      )(_.resource)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(detailType.map(value => value.unwrap))(_.detailType)
      .optionallyWith(
        createdBy.map(value =>
          NotificationRuleCreatedBy.unwrap(value): java.lang.String
        )
      )(_.createdBy)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdTimestamp.map(value => CreatedTimestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastModifiedTimestamp.map(value =>
          LastModifiedTimestamp.unwrap(value): Instant
        )
      )(_.lastModifiedTimestamp)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly =
    zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse
      .wrap(buildAwsValue())
}
object DescribeNotificationRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse =
      zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse(
        arn,
        name.map(value => value),
        eventTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resource.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        detailType.map(value => value),
        createdBy.map(value => value),
        status.map(value => value),
        createdTimestamp.map(value => value),
        lastModifiedTimestamp.map(value => value),
        tags.map(value => value)
      )
    def arn: NotificationRuleArn
    def name: Optional[NotificationRuleName]
    def eventTypes: Optional[
      List[zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly]
    ]
    def resource: Optional[NotificationRuleResource]
    def targets: Optional[
      List[zio.aws.codestarnotifications.model.TargetSummary.ReadOnly]
    ]
    def detailType: Optional[zio.aws.codestarnotifications.model.DetailType]
    def createdBy: Optional[NotificationRuleCreatedBy]
    def status
        : Optional[zio.aws.codestarnotifications.model.NotificationRuleStatus]
    def createdTimestamp: Optional[CreatedTimestamp]
    def lastModifiedTimestamp: Optional[LastModifiedTimestamp]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, NotificationRuleName] =
      AwsError.unwrapOptionField("name", name)
    def getEventTypes: ZIO[Any, AwsError, List[
      zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("eventTypes", eventTypes)
    def getResource: ZIO[Any, AwsError, NotificationRuleResource] =
      AwsError.unwrapOptionField("resource", resource)
    def getTargets: ZIO[Any, AwsError, List[
      zio.aws.codestarnotifications.model.TargetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("targets", targets)
    def getDetailType
        : ZIO[Any, AwsError, zio.aws.codestarnotifications.model.DetailType] =
      AwsError.unwrapOptionField("detailType", detailType)
    def getCreatedBy: ZIO[Any, AwsError, NotificationRuleCreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codestarnotifications.model.NotificationRuleStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreatedTimestamp: ZIO[Any, AwsError, CreatedTimestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, LastModifiedTimestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse
  ) extends zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
    override val name: Optional[NotificationRuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .NotificationRuleName(value)
      )
    override val eventTypes: Optional[
      List[zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarnotifications.model.EventTypeSummary.wrap(item)
        }.toList
      )
    override val resource: Optional[NotificationRuleResource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resource())
        .map(value =>
          zio.aws.codestarnotifications.model.primitives
            .NotificationRuleResource(value)
        )
    override val targets: Optional[
      List[zio.aws.codestarnotifications.model.TargetSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarnotifications.model.TargetSummary.wrap(item)
        }.toList
      )
    override val detailType
        : Optional[zio.aws.codestarnotifications.model.DetailType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detailType())
        .map(value =>
          zio.aws.codestarnotifications.model.DetailType.wrap(value)
        )
    override val createdBy: Optional[NotificationRuleCreatedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value =>
          zio.aws.codestarnotifications.model.primitives
            .NotificationRuleCreatedBy(value)
        )
    override val status
        : Optional[zio.aws.codestarnotifications.model.NotificationRuleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codestarnotifications.model.NotificationRuleStatus.wrap(value)
        )
    override val createdTimestamp: Optional[CreatedTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.codestarnotifications.model.primitives.CreatedTimestamp(value)
        )
    override val lastModifiedTimestamp: Optional[LastModifiedTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimestamp())
        .map(value =>
          zio.aws.codestarnotifications.model.primitives
            .LastModifiedTimestamp(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codestarnotifications.model.primitives.TagKey(
              key
            ) -> zio.aws.codestarnotifications.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse
  ): zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly =
    new Wrapper(impl)
}
