package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.NotificationRuleArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeNotificationRuleRequest(arn: NotificationRuleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleRequest = {
    import DescribeNotificationRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleRequest
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.DescribeNotificationRuleRequest.ReadOnly =
    zio.aws.codestarnotifications.model.DescribeNotificationRuleRequest
      .wrap(buildAwsValue())
}
object DescribeNotificationRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.DescribeNotificationRuleRequest =
      zio.aws.codestarnotifications.model.DescribeNotificationRuleRequest(arn)
    def arn: NotificationRuleArn
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleRequest
  ) extends zio.aws.codestarnotifications.model.DescribeNotificationRuleRequest.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleRequest
  ): zio.aws.codestarnotifications.model.DescribeNotificationRuleRequest.ReadOnly =
    new Wrapper(impl)
}
