package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  TargetType,
  TargetAddress
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TargetSummary(
    targetAddress: Option[TargetAddress] = None,
    targetType: Option[TargetType] = None,
    targetStatus: Option[zio.aws.codestarnotifications.model.TargetStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.TargetSummary = {
    import TargetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.TargetSummary
      .builder()
      .optionallyWith(
        targetAddress.map(value =>
          TargetAddress.unwrap(value): java.lang.String
        )
      )(_.targetAddress)
      .optionallyWith(
        targetType.map(value => TargetType.unwrap(value): java.lang.String)
      )(_.targetType)
      .optionallyWith(targetStatus.map(value => value.unwrap))(_.targetStatus)
      .build()
  }
  def asReadOnly: zio.aws.codestarnotifications.model.TargetSummary.ReadOnly =
    zio.aws.codestarnotifications.model.TargetSummary.wrap(buildAwsValue())
}
object TargetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.TargetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.TargetSummary =
      zio.aws.codestarnotifications.model.TargetSummary(
        targetAddress.map(value => value),
        targetType.map(value => value),
        targetStatus.map(value => value)
      )
    def targetAddress: Option[TargetAddress]
    def targetType: Option[TargetType]
    def targetStatus: Option[zio.aws.codestarnotifications.model.TargetStatus]
    def getTargetAddress: ZIO[Any, AwsError, TargetAddress] =
      AwsError.unwrapOptionField("targetAddress", targetAddress)
    def getTargetType: ZIO[Any, AwsError, TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getTargetStatus
        : ZIO[Any, AwsError, zio.aws.codestarnotifications.model.TargetStatus] =
      AwsError.unwrapOptionField("targetStatus", targetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.TargetSummary
  ) extends zio.aws.codestarnotifications.model.TargetSummary.ReadOnly {
    override val targetAddress: Option[TargetAddress] = scala
      .Option(impl.targetAddress())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.TargetAddress(value)
      )
    override val targetType: Option[TargetType] = scala
      .Option(impl.targetType())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.TargetType(value)
      )
    override val targetStatus
        : Option[zio.aws.codestarnotifications.model.TargetStatus] = scala
      .Option(impl.targetStatus())
      .map(value =>
        zio.aws.codestarnotifications.model.TargetStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.TargetSummary
  ): zio.aws.codestarnotifications.model.TargetSummary.ReadOnly = new Wrapper(
    impl
  )
}
