package zio.aws.codestarnotifications.model
import scala.jdk.CollectionConverters._
sealed trait NotificationRuleStatus {
  def unwrap: software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus
}
object NotificationRuleStatus {
  def wrap(
      value: software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus
  ): zio.aws.codestarnotifications.model.NotificationRuleStatus = value match {
    case software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codestarnotifications.model.NotificationRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus =
      software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.codestarnotifications.model.NotificationRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus =
      software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus.ENABLED
  }
  case object DISABLED
      extends zio.aws.codestarnotifications.model.NotificationRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus =
      software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus.DISABLED
  }
}
