package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.NotificationRuleArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNotificationRuleResponse(
    arn: Option[NotificationRuleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleResponse = {
    import CreateNotificationRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleResponse
      .builder()
      .optionallyWith(
        arn.map(value => NotificationRuleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.CreateNotificationRuleResponse.ReadOnly =
    zio.aws.codestarnotifications.model.CreateNotificationRuleResponse
      .wrap(buildAwsValue())
}
object CreateNotificationRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.CreateNotificationRuleResponse =
      zio.aws.codestarnotifications.model
        .CreateNotificationRuleResponse(arn.map(value => value))
    def arn: Option[NotificationRuleArn]
    def getArn: ZIO[Any, AwsError, NotificationRuleArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleResponse
  ) extends zio.aws.codestarnotifications.model.CreateNotificationRuleResponse.ReadOnly {
    override val arn: Option[NotificationRuleArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .NotificationRuleArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleResponse
  ): zio.aws.codestarnotifications.model.CreateNotificationRuleResponse.ReadOnly =
    new Wrapper(impl)
}
