package zio.aws.codestarnotifications.model
import scala.jdk.CollectionConverters._
sealed trait DetailType {
  def unwrap
      : software.amazon.awssdk.services.codestarnotifications.model.DetailType
}
object DetailType {
  def wrap(
      value: software.amazon.awssdk.services.codestarnotifications.model.DetailType
  ): zio.aws.codestarnotifications.model.DetailType = value match {
    case software.amazon.awssdk.services.codestarnotifications.model.DetailType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codestarnotifications.model.DetailType.BASIC =>
      val r = BASIC
      r
    case software.amazon.awssdk.services.codestarnotifications.model.DetailType.FULL =>
      val r = FULL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codestarnotifications.model.DetailType {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.DetailType =
      software.amazon.awssdk.services.codestarnotifications.model.DetailType.UNKNOWN_TO_SDK_VERSION
  }
  case object BASIC extends zio.aws.codestarnotifications.model.DetailType {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.DetailType =
      software.amazon.awssdk.services.codestarnotifications.model.DetailType.BASIC
  }
  case object FULL extends zio.aws.codestarnotifications.model.DetailType {
    override def unwrap
        : software.amazon.awssdk.services.codestarnotifications.model.DetailType =
      software.amazon.awssdk.services.codestarnotifications.model.DetailType.FULL
  }
}
