package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  TargetAddress,
  NotificationRuleArn
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UnsubscribeRequest(
    arn: NotificationRuleArn,
    targetAddress: TargetAddress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeRequest = {
    import UnsubscribeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeRequest
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .targetAddress(TargetAddress.unwrap(targetAddress): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.UnsubscribeRequest.ReadOnly =
    zio.aws.codestarnotifications.model.UnsubscribeRequest.wrap(buildAwsValue())
}
object UnsubscribeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.UnsubscribeRequest =
      zio.aws.codestarnotifications.model.UnsubscribeRequest(arn, targetAddress)
    def arn: NotificationRuleArn
    def targetAddress: TargetAddress
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
    def getTargetAddress: ZIO[Any, Nothing, TargetAddress] =
      ZIO.succeed(targetAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeRequest
  ) extends zio.aws.codestarnotifications.model.UnsubscribeRequest.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
    override val targetAddress: TargetAddress =
      zio.aws.codestarnotifications.model.primitives
        .TargetAddress(impl.targetAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeRequest
  ): zio.aws.codestarnotifications.model.UnsubscribeRequest.ReadOnly =
    new Wrapper(impl)
}
