package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.ListEventTypesFilterValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListEventTypesFilter(
    name: zio.aws.codestarnotifications.model.ListEventTypesFilterName,
    value: ListEventTypesFilterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesFilter = {
    import ListEventTypesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesFilter
      .builder()
      .name(name.unwrap)
      .value(ListEventTypesFilterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.ListEventTypesFilter.ReadOnly =
    zio.aws.codestarnotifications.model.ListEventTypesFilter
      .wrap(buildAwsValue())
}
object ListEventTypesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.ListEventTypesFilter =
      zio.aws.codestarnotifications.model.ListEventTypesFilter(name, value)
    def name: zio.aws.codestarnotifications.model.ListEventTypesFilterName
    def value: ListEventTypesFilterValue
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.codestarnotifications.model.ListEventTypesFilterName
    ] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, ListEventTypesFilterValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesFilter
  ) extends zio.aws.codestarnotifications.model.ListEventTypesFilter.ReadOnly {
    override val name
        : zio.aws.codestarnotifications.model.ListEventTypesFilterName =
      zio.aws.codestarnotifications.model.ListEventTypesFilterName
        .wrap(impl.name())
    override val value: ListEventTypesFilterValue =
      zio.aws.codestarnotifications.model.primitives
        .ListEventTypesFilterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesFilter
  ): zio.aws.codestarnotifications.model.ListEventTypesFilter.ReadOnly =
    new Wrapper(impl)
}
