package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  NotificationRuleArn,
  NotificationRuleId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NotificationRuleSummary(
    id: Optional[NotificationRuleId] = Optional.Absent,
    arn: Optional[NotificationRuleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary = {
    import NotificationRuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary
      .builder()
      .optionallyWith(
        id.map(value => NotificationRuleId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => NotificationRuleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly =
    zio.aws.codestarnotifications.model.NotificationRuleSummary
      .wrap(buildAwsValue())
}
object NotificationRuleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.NotificationRuleSummary =
      zio.aws.codestarnotifications.model.NotificationRuleSummary(
        id.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[NotificationRuleId]
    def arn: Optional[NotificationRuleArn]
    def getId: ZIO[Any, AwsError, NotificationRuleId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, NotificationRuleArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary
  ) extends zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly {
    override val id: Optional[NotificationRuleId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.NotificationRuleId(value)
      )
    override val arn: Optional[NotificationRuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .NotificationRuleArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary
  ): zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly =
    new Wrapper(impl)
}
