package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.ListNotificationRulesFilterValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListNotificationRulesFilter(
    name: zio.aws.codestarnotifications.model.ListNotificationRulesFilterName,
    value: ListNotificationRulesFilterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesFilter = {
    import ListNotificationRulesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesFilter
      .builder()
      .name(name.unwrap)
      .value(ListNotificationRulesFilterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.ListNotificationRulesFilter.ReadOnly =
    zio.aws.codestarnotifications.model.ListNotificationRulesFilter
      .wrap(buildAwsValue())
}
object ListNotificationRulesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.ListNotificationRulesFilter =
      zio.aws.codestarnotifications.model
        .ListNotificationRulesFilter(name, value)
    def name
        : zio.aws.codestarnotifications.model.ListNotificationRulesFilterName
    def value: ListNotificationRulesFilterValue
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.codestarnotifications.model.ListNotificationRulesFilterName
    ] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, ListNotificationRulesFilterValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesFilter
  ) extends zio.aws.codestarnotifications.model.ListNotificationRulesFilter.ReadOnly {
    override val name
        : zio.aws.codestarnotifications.model.ListNotificationRulesFilterName =
      zio.aws.codestarnotifications.model.ListNotificationRulesFilterName
        .wrap(impl.name())
    override val value: ListNotificationRulesFilterValue =
      zio.aws.codestarnotifications.model.primitives
        .ListNotificationRulesFilterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesFilter
  ): zio.aws.codestarnotifications.model.ListNotificationRulesFilter.ReadOnly =
    new Wrapper(impl)
}
