package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.HostArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateHostResponse(
    hostArn: Optional[HostArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.codestarconnections.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.CreateHostResponse = {
    import CreateHostResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.CreateHostResponse
      .builder()
      .optionallyWith(
        hostArn.map(value => HostArn.unwrap(value): java.lang.String)
      )(_.hostArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.CreateHostResponse.ReadOnly =
    zio.aws.codestarconnections.model.CreateHostResponse.wrap(buildAwsValue())
}
object CreateHostResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.CreateHostResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.CreateHostResponse =
      zio.aws.codestarconnections.model.CreateHostResponse(
        hostArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hostArn: Optional[HostArn]
    def tags: Optional[List[zio.aws.codestarconnections.model.Tag.ReadOnly]]
    def getHostArn: ZIO[Any, AwsError, HostArn] =
      AwsError.unwrapOptionField("hostArn", hostArn)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.codestarconnections.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.CreateHostResponse
  ) extends zio.aws.codestarconnections.model.CreateHostResponse.ReadOnly {
    override val hostArn: Optional[HostArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hostArn())
      .map(value => zio.aws.codestarconnections.model.primitives.HostArn(value))
    override val tags
        : Optional[List[zio.aws.codestarconnections.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codestarconnections.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.CreateHostResponse
  ): zio.aws.codestarconnections.model.CreateHostResponse.ReadOnly =
    new Wrapper(impl)
}
