package zio.aws.codestarconnections.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestarconnections.model.primitives.{
  NextToken,
  MaxResults,
  HostArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListConnectionsRequest(
    providerTypeFilter: Optional[
      zio.aws.codestarconnections.model.ProviderType
    ] = Optional.Absent,
    hostArnFilter: Optional[HostArn] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest = {
    import ListConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest
      .builder()
      .optionallyWith(providerTypeFilter.map(value => value.unwrap))(
        _.providerTypeFilter
      )
      .optionallyWith(
        hostArnFilter.map(value => HostArn.unwrap(value): java.lang.String)
      )(_.hostArnFilter)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.ListConnectionsRequest.ReadOnly =
    zio.aws.codestarconnections.model.ListConnectionsRequest
      .wrap(buildAwsValue())
}
object ListConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.ListConnectionsRequest =
      zio.aws.codestarconnections.model.ListConnectionsRequest(
        providerTypeFilter.map(value => value),
        hostArnFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def providerTypeFilter
        : Optional[zio.aws.codestarconnections.model.ProviderType]
    def hostArnFilter: Optional[HostArn]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getProviderTypeFilter
        : ZIO[Any, AwsError, zio.aws.codestarconnections.model.ProviderType] =
      AwsError.unwrapOptionField("providerTypeFilter", providerTypeFilter)
    def getHostArnFilter: ZIO[Any, AwsError, HostArn] =
      AwsError.unwrapOptionField("hostArnFilter", hostArnFilter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest
  ) extends zio.aws.codestarconnections.model.ListConnectionsRequest.ReadOnly {
    override val providerTypeFilter
        : Optional[zio.aws.codestarconnections.model.ProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerTypeFilter())
        .map(value =>
          zio.aws.codestarconnections.model.ProviderType.wrap(value)
        )
    override val hostArnFilter: Optional[HostArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hostArnFilter())
      .map(value => zio.aws.codestarconnections.model.primitives.HostArn(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest
  ): zio.aws.codestarconnections.model.ListConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
