package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.{HostArn, ConnectionName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConnectionRequest(
    providerType: Optional[zio.aws.codestarconnections.model.ProviderType] =
      Optional.Absent,
    connectionName: ConnectionName,
    tags: Optional[Iterable[zio.aws.codestarconnections.model.Tag]] =
      Optional.Absent,
    hostArn: Optional[HostArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.CreateConnectionRequest = {
    import CreateConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.CreateConnectionRequest
      .builder()
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .connectionName(ConnectionName.unwrap(connectionName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        hostArn.map(value => HostArn.unwrap(value): java.lang.String)
      )(_.hostArn)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.CreateConnectionRequest.ReadOnly =
    zio.aws.codestarconnections.model.CreateConnectionRequest
      .wrap(buildAwsValue())
}
object CreateConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.CreateConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.CreateConnectionRequest =
      zio.aws.codestarconnections.model.CreateConnectionRequest(
        providerType.map(value => value),
        connectionName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostArn.map(value => value)
      )
    def providerType: Optional[zio.aws.codestarconnections.model.ProviderType]
    def connectionName: ConnectionName
    def tags: Optional[List[zio.aws.codestarconnections.model.Tag.ReadOnly]]
    def hostArn: Optional[HostArn]
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codestarconnections.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getConnectionName: ZIO[Any, Nothing, ConnectionName] =
      ZIO.succeed(connectionName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.codestarconnections.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getHostArn: ZIO[Any, AwsError, HostArn] =
      AwsError.unwrapOptionField("hostArn", hostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.CreateConnectionRequest
  ) extends zio.aws.codestarconnections.model.CreateConnectionRequest.ReadOnly {
    override val providerType
        : Optional[zio.aws.codestarconnections.model.ProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerType())
        .map(value =>
          zio.aws.codestarconnections.model.ProviderType.wrap(value)
        )
    override val connectionName: ConnectionName =
      zio.aws.codestarconnections.model.primitives
        .ConnectionName(impl.connectionName())
    override val tags
        : Optional[List[zio.aws.codestarconnections.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codestarconnections.model.Tag.wrap(item)
          }.toList
        )
    override val hostArn: Optional[HostArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hostArn())
      .map(value => zio.aws.codestarconnections.model.primitives.HostArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.CreateConnectionRequest
  ): zio.aws.codestarconnections.model.CreateConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
