package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetConnectionResponse(
    connection: Optional[zio.aws.codestarconnections.model.Connection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse = {
    import GetConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly =
    zio.aws.codestarconnections.model.GetConnectionResponse
      .wrap(buildAwsValue())
}
object GetConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.GetConnectionResponse =
      zio.aws.codestarconnections.model
        .GetConnectionResponse(connection.map(value => value.asEditable))
    def connection
        : Optional[zio.aws.codestarconnections.model.Connection.ReadOnly]
    def getConnection: ZIO[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.Connection.ReadOnly
    ] = AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse
  ) extends zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.codestarconnections.model.Connection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.codestarconnections.model.Connection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse
  ): zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
