package zio.aws.codestarconnections
import zio.aws.codestarconnections.model.ListHostsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.codestarconnections.model.{
  GetConnectionRequest,
  CreateHostRequest,
  ListHostsRequest,
  CreateConnectionRequest,
  ListTagsForResourceRequest,
  GetHostRequest,
  DeleteConnectionRequest,
  DeleteHostRequest,
  UpdateHostRequest,
  UntagResourceRequest,
  ListConnectionsRequest,
  TagResourceRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsAsyncClient
import zio.stream.ZStream
object CodeStarConnectionsMock extends Mock[CodeStarConnections] {
  object CreateConnection
      extends Effect[
        CreateConnectionRequest,
        AwsError,
        zio.aws.codestarconnections.model.CreateConnectionResponse.ReadOnly
      ]
  object DeleteHost
      extends Effect[
        DeleteHostRequest,
        AwsError,
        zio.aws.codestarconnections.model.DeleteHostResponse.ReadOnly
      ]
  object UpdateHost
      extends Effect[
        UpdateHostRequest,
        AwsError,
        zio.aws.codestarconnections.model.UpdateHostResponse.ReadOnly
      ]
  object ListConnections
      extends Stream[
        ListConnectionsRequest,
        AwsError,
        zio.aws.codestarconnections.model.Connection.ReadOnly
      ]
  object ListConnectionsPaginated
      extends Effect[
        ListConnectionsRequest,
        AwsError,
        zio.aws.codestarconnections.model.ListConnectionsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.codestarconnections.model.UntagResourceResponse.ReadOnly
      ]
  object CreateHost
      extends Effect[
        CreateHostRequest,
        AwsError,
        zio.aws.codestarconnections.model.CreateHostResponse.ReadOnly
      ]
  object GetHost
      extends Effect[
        GetHostRequest,
        AwsError,
        zio.aws.codestarconnections.model.GetHostResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codestarconnections.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteConnection
      extends Effect[
        DeleteConnectionRequest,
        AwsError,
        zio.aws.codestarconnections.model.DeleteConnectionResponse.ReadOnly
      ]
  object ListHosts
      extends Stream[
        ListHostsRequest,
        AwsError,
        zio.aws.codestarconnections.model.Host.ReadOnly
      ]
  object ListHostsPaginated extends Effect[ListHostsRequest, AwsError, ReadOnly]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.codestarconnections.model.TagResourceResponse.ReadOnly
      ]
  object GetConnection
      extends Effect[
        GetConnectionRequest,
        AwsError,
        zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CodeStarConnections] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CodeStarConnections] { rts =>
        zio.ZIO.succeed {
          new CodeStarConnections {
            val api: CodeStarConnectionsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CodeStarConnections = this
            def createConnection(request: CreateConnectionRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.CreateConnectionResponse.ReadOnly
            ] = proxy(CreateConnection, request)
            def deleteHost(request: DeleteHostRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.DeleteHostResponse.ReadOnly
            ] = proxy(DeleteHost, request)
            def updateHost(request: UpdateHostRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.UpdateHostResponse.ReadOnly
            ] = proxy(UpdateHost, request)
            def listConnections(request: ListConnectionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codestarconnections.model.Connection.ReadOnly
            ] = rts.unsafeRun(proxy(ListConnections, request))
            def listConnectionsPaginated(request: ListConnectionsRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.ListConnectionsResponse.ReadOnly
            ] = proxy(ListConnectionsPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createHost(request: CreateHostRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.CreateHostResponse.ReadOnly
            ] = proxy(CreateHost, request)
            def getHost(request: GetHostRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.GetHostResponse.ReadOnly
            ] = proxy(GetHost, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def deleteConnection(request: DeleteConnectionRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.DeleteConnectionResponse.ReadOnly
            ] = proxy(DeleteConnection, request)
            def listHosts(request: ListHostsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codestarconnections.model.Host.ReadOnly
            ] = rts.unsafeRun(proxy(ListHosts, request))
            def listHostsPaginated(
                request: ListHostsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListHostsPaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def getConnection(request: GetConnectionRequest): IO[
              AwsError,
              zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly
            ] = proxy(GetConnection, request)
          }
        }
      }
    }
  }
}
