package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.{
  HostArn,
  AccountId,
  ConnectionArn,
  ConnectionName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Connection(
    connectionName: Optional[ConnectionName] = Optional.Absent,
    connectionArn: Optional[ConnectionArn] = Optional.Absent,
    providerType: Optional[zio.aws.codestarconnections.model.ProviderType] =
      Optional.Absent,
    ownerAccountId: Optional[AccountId] = Optional.Absent,
    connectionStatus: Optional[
      zio.aws.codestarconnections.model.ConnectionStatus
    ] = Optional.Absent,
    hostArn: Optional[HostArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.Connection = {
    import Connection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.Connection
      .builder()
      .optionallyWith(
        connectionName.map(value =>
          ConnectionName.unwrap(value): java.lang.String
        )
      )(_.connectionName)
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(connectionStatus.map(value => value.unwrap))(
        _.connectionStatus
      )
      .optionallyWith(
        hostArn.map(value => HostArn.unwrap(value): java.lang.String)
      )(_.hostArn)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.Connection.ReadOnly =
    zio.aws.codestarconnections.model.Connection.wrap(buildAwsValue())
}
object Connection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.Connection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.Connection =
      zio.aws.codestarconnections.model.Connection(
        connectionName.map(value => value),
        connectionArn.map(value => value),
        providerType.map(value => value),
        ownerAccountId.map(value => value),
        connectionStatus.map(value => value),
        hostArn.map(value => value)
      )
    def connectionName: Optional[ConnectionName]
    def connectionArn: Optional[ConnectionArn]
    def providerType: Optional[zio.aws.codestarconnections.model.ProviderType]
    def ownerAccountId: Optional[AccountId]
    def connectionStatus
        : Optional[zio.aws.codestarconnections.model.ConnectionStatus]
    def hostArn: Optional[HostArn]
    def getConnectionName: ZIO[Any, AwsError, ConnectionName] =
      AwsError.unwrapOptionField("connectionName", connectionName)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codestarconnections.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.ConnectionStatus
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
    def getHostArn: ZIO[Any, AwsError, HostArn] =
      AwsError.unwrapOptionField("hostArn", hostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.Connection
  ) extends zio.aws.codestarconnections.model.Connection.ReadOnly {
    override val connectionName: Optional[ConnectionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionName())
        .map(value =>
          zio.aws.codestarconnections.model.primitives.ConnectionName(value)
        )
    override val connectionArn: Optional[ConnectionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionArn())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.ConnectionArn(value)
      )
    override val providerType
        : Optional[zio.aws.codestarconnections.model.ProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerType())
        .map(value =>
          zio.aws.codestarconnections.model.ProviderType.wrap(value)
        )
    override val ownerAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.AccountId(value)
      )
    override val connectionStatus
        : Optional[zio.aws.codestarconnections.model.ConnectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionStatus())
        .map(value =>
          zio.aws.codestarconnections.model.ConnectionStatus.wrap(value)
        )
    override val hostArn: Optional[HostArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hostArn())
      .map(value => zio.aws.codestarconnections.model.primitives.HostArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.Connection
  ): zio.aws.codestarconnections.model.Connection.ReadOnly = new Wrapper(impl)
}
