package zio.aws.codestarconnections.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionStatus {
  def unwrap: software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus
}
object ConnectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus
  ): zio.aws.codestarconnections.model.ConnectionStatus = value match {
    case software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codestarconnections.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus =
      software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.codestarconnections.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus =
      software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus.PENDING
  }
  case object AVAILABLE
      extends zio.aws.codestarconnections.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus =
      software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus.AVAILABLE
  }
  case object ERROR extends zio.aws.codestarconnections.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus =
      software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus.ERROR
  }
}
