package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListHostsResponse(
    hosts: Optional[Iterable[zio.aws.codestarconnections.model.Host]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse = {
    import ListHostsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse
      .builder()
      .optionallyWith(
        hosts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hosts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.ListHostsResponse.ReadOnly =
    zio.aws.codestarconnections.model.ListHostsResponse.wrap(buildAwsValue())
}
object ListHostsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.ListHostsResponse =
      zio.aws.codestarconnections.model.ListHostsResponse(
        hosts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def hosts: Optional[List[zio.aws.codestarconnections.model.Host.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getHosts: ZIO[Any, AwsError, List[
      zio.aws.codestarconnections.model.Host.ReadOnly
    ]] = AwsError.unwrapOptionField("hosts", hosts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse
  ) extends zio.aws.codestarconnections.model.ListHostsResponse.ReadOnly {
    override val hosts
        : Optional[List[zio.aws.codestarconnections.model.Host.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hosts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codestarconnections.model.Host.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse
  ): zio.aws.codestarconnections.model.ListHostsResponse.ReadOnly = new Wrapper(
    impl
  )
}
