package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetConnectionResponse(
    connection: Option[zio.aws.codestarconnections.model.Connection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse = {
    import GetConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly =
    zio.aws.codestarconnections.model.GetConnectionResponse
      .wrap(buildAwsValue())
}
object GetConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.GetConnectionResponse =
      zio.aws.codestarconnections.model
        .GetConnectionResponse(connection.map(value => value.asEditable))
    def connection
        : Option[zio.aws.codestarconnections.model.Connection.ReadOnly]
    def getConnection: ZIO[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.Connection.ReadOnly
    ] = AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse
  ) extends zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly {
    override val connection
        : Option[zio.aws.codestarconnections.model.Connection.ReadOnly] = scala
      .Option(impl.connection())
      .map(value => zio.aws.codestarconnections.model.Connection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse
  ): zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
