package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.{
  HostArn,
  AccountId,
  ConnectionArn,
  ConnectionName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Connection(
    connectionName: Option[ConnectionName] = None,
    connectionArn: Option[ConnectionArn] = None,
    providerType: Option[zio.aws.codestarconnections.model.ProviderType] = None,
    ownerAccountId: Option[AccountId] = None,
    connectionStatus: Option[
      zio.aws.codestarconnections.model.ConnectionStatus
    ] = None,
    hostArn: Option[HostArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.Connection = {
    import Connection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.Connection
      .builder()
      .optionallyWith(
        connectionName.map(value =>
          ConnectionName.unwrap(value): java.lang.String
        )
      )(_.connectionName)
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(connectionStatus.map(value => value.unwrap))(
        _.connectionStatus
      )
      .optionallyWith(
        hostArn.map(value => HostArn.unwrap(value): java.lang.String)
      )(_.hostArn)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.Connection.ReadOnly =
    zio.aws.codestarconnections.model.Connection.wrap(buildAwsValue())
}
object Connection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.Connection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.Connection =
      zio.aws.codestarconnections.model.Connection(
        connectionName.map(value => value),
        connectionArn.map(value => value),
        providerType.map(value => value),
        ownerAccountId.map(value => value),
        connectionStatus.map(value => value),
        hostArn.map(value => value)
      )
    def connectionName: Option[ConnectionName]
    def connectionArn: Option[ConnectionArn]
    def providerType: Option[zio.aws.codestarconnections.model.ProviderType]
    def ownerAccountId: Option[AccountId]
    def connectionStatus
        : Option[zio.aws.codestarconnections.model.ConnectionStatus]
    def hostArn: Option[HostArn]
    def getConnectionName: ZIO[Any, AwsError, ConnectionName] =
      AwsError.unwrapOptionField("connectionName", connectionName)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codestarconnections.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.ConnectionStatus
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
    def getHostArn: ZIO[Any, AwsError, HostArn] =
      AwsError.unwrapOptionField("hostArn", hostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.Connection
  ) extends zio.aws.codestarconnections.model.Connection.ReadOnly {
    override val connectionName: Option[ConnectionName] = scala
      .Option(impl.connectionName())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.ConnectionName(value)
      )
    override val connectionArn: Option[ConnectionArn] = scala
      .Option(impl.connectionArn())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.ConnectionArn(value)
      )
    override val providerType
        : Option[zio.aws.codestarconnections.model.ProviderType] = scala
      .Option(impl.providerType())
      .map(value => zio.aws.codestarconnections.model.ProviderType.wrap(value))
    override val ownerAccountId: Option[AccountId] = scala
      .Option(impl.ownerAccountId())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.AccountId(value)
      )
    override val connectionStatus
        : Option[zio.aws.codestarconnections.model.ConnectionStatus] = scala
      .Option(impl.connectionStatus())
      .map(value =>
        zio.aws.codestarconnections.model.ConnectionStatus.wrap(value)
      )
    override val hostArn: Option[HostArn] = scala
      .Option(impl.hostArn())
      .map(value => zio.aws.codestarconnections.model.primitives.HostArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.Connection
  ): zio.aws.codestarconnections.model.Connection.ReadOnly = new Wrapper(impl)
}
