package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.HostArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteHostRequest(hostArn: HostArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.DeleteHostRequest = {
    import DeleteHostRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.DeleteHostRequest
      .builder()
      .hostArn(HostArn.unwrap(hostArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.DeleteHostRequest.ReadOnly =
    zio.aws.codestarconnections.model.DeleteHostRequest.wrap(buildAwsValue())
}
object DeleteHostRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.DeleteHostRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.DeleteHostRequest =
      zio.aws.codestarconnections.model.DeleteHostRequest(hostArn)
    def hostArn: HostArn
    def getHostArn: ZIO[Any, Nothing, HostArn] = ZIO.succeed(hostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.DeleteHostRequest
  ) extends zio.aws.codestarconnections.model.DeleteHostRequest.ReadOnly {
    override val hostArn: HostArn =
      zio.aws.codestarconnections.model.primitives.HostArn(impl.hostArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.DeleteHostRequest
  ): zio.aws.codestarconnections.model.DeleteHostRequest.ReadOnly = new Wrapper(
    impl
  )
}
