package zio.aws.codestarconnections
import zio.aws.codestarconnections.model.ListHostsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.codestarconnections.model.{
  GetConnectionRequest,
  CreateHostRequest,
  ListHostsRequest,
  CreateConnectionRequest,
  ListTagsForResourceRequest,
  GetHostRequest,
  DeleteConnectionRequest,
  DeleteHostRequest,
  UpdateHostRequest,
  UntagResourceRequest,
  ListConnectionsRequest,
  TagResourceRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.codestarconnections.{
  CodeStarConnectionsAsyncClientBuilder,
  CodeStarConnectionsAsyncClient
}
import software.amazon.awssdk.services.codestarconnections.model.{
  ListHostsResponse,
  Host,
  ListConnectionsResponse,
  DeleteConnectionResponse,
  DeleteHostResponse,
  CreateConnectionResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetHostResponse,
  Connection,
  GetConnectionResponse,
  CreateHostResponse,
  TagResourceResponse,
  UpdateHostResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait CodeStarConnections extends AspectSupport[CodeStarConnections] {
  val api: CodeStarConnectionsAsyncClient
  def createConnection(request: CreateConnectionRequest): IO[
    AwsError,
    zio.aws.codestarconnections.model.CreateConnectionResponse.ReadOnly
  ]
  def deleteHost(
      request: DeleteHostRequest
  ): IO[AwsError, zio.aws.codestarconnections.model.DeleteHostResponse.ReadOnly]
  def updateHost(
      request: UpdateHostRequest
  ): IO[AwsError, zio.aws.codestarconnections.model.UpdateHostResponse.ReadOnly]
  def listConnections(request: ListConnectionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.codestarconnections.model.Connection.ReadOnly
  ]
  def listConnectionsPaginated(request: ListConnectionsRequest): IO[
    AwsError,
    zio.aws.codestarconnections.model.ListConnectionsResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.codestarconnections.model.UntagResourceResponse.ReadOnly
  ]
  def createHost(
      request: CreateHostRequest
  ): IO[AwsError, zio.aws.codestarconnections.model.CreateHostResponse.ReadOnly]
  def getHost(
      request: GetHostRequest
  ): IO[AwsError, zio.aws.codestarconnections.model.GetHostResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.codestarconnections.model.ListTagsForResourceResponse.ReadOnly
  ]
  def deleteConnection(request: DeleteConnectionRequest): IO[
    AwsError,
    zio.aws.codestarconnections.model.DeleteConnectionResponse.ReadOnly
  ]
  def listHosts(
      request: ListHostsRequest
  ): ZStream[Any, AwsError, zio.aws.codestarconnections.model.Host.ReadOnly]
  def listHostsPaginated(request: ListHostsRequest): IO[AwsError, ReadOnly]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.codestarconnections.model.TagResourceResponse.ReadOnly
  ]
  def getConnection(request: GetConnectionRequest): IO[
    AwsError,
    zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly
  ]
}
object CodeStarConnections {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodeStarConnections] =
    customized(identity)
  def customized(
      customization: CodeStarConnectionsAsyncClientBuilder => CodeStarConnectionsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodeStarConnections] = managed(
    customization
  ).toLayer
  def managed(
      customization: CodeStarConnectionsAsyncClientBuilder => CodeStarConnectionsAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CodeStarConnections] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CodeStarConnectionsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        CodeStarConnectionsAsyncClient,
        CodeStarConnectionsAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        CodeStarConnectionsAsyncClient,
        CodeStarConnectionsAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new CodeStarConnectionsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CodeStarConnectionsImpl[R](
      override val api: CodeStarConnectionsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodeStarConnections
      with AwsServiceBase[R] {
    override val serviceName: String = "CodeStarConnections"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodeStarConnectionsImpl[R1] =
      new CodeStarConnectionsImpl(api, newAspect, r)
    def createConnection(request: CreateConnectionRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.CreateConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.CreateConnectionRequest,
      CreateConnectionResponse
    ]("createConnection", api.createConnection)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.CreateConnectionResponse.wrap)
      .provideEnvironment(r)
    def deleteHost(request: DeleteHostRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.DeleteHostResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.DeleteHostRequest,
      DeleteHostResponse
    ]("deleteHost", api.deleteHost)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.DeleteHostResponse.wrap)
      .provideEnvironment(r)
    def updateHost(request: UpdateHostRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.UpdateHostResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.UpdateHostRequest,
      UpdateHostResponse
    ]("updateHost", api.updateHost)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.UpdateHostResponse.wrap)
      .provideEnvironment(r)
    def listConnections(request: ListConnectionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.Connection.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest,
      ListConnectionsResponse,
      Connection
    ](
      "listConnections",
      api.listConnections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connections().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.codestarconnections.model.Connection.wrap(item))
      .provideEnvironment(r)
    def listConnectionsPaginated(request: ListConnectionsRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.ListConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest,
      ListConnectionsResponse
    ]("listConnections", api.listConnections)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.ListConnectionsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def createHost(request: CreateHostRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.CreateHostResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.CreateHostRequest,
      CreateHostResponse
    ]("createHost", api.createHost)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.CreateHostResponse.wrap)
      .provideEnvironment(r)
    def getHost(request: GetHostRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.GetHostResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.GetHostRequest,
      GetHostResponse
    ]("getHost", api.getHost)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.GetHostResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteConnection(request: DeleteConnectionRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.DeleteConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.DeleteConnectionRequest,
      DeleteConnectionResponse
    ]("deleteConnection", api.deleteConnection)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.DeleteConnectionResponse.wrap)
      .provideEnvironment(r)
    def listHosts(request: ListHostsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.Host.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest,
      ListHostsResponse,
      Host
    ](
      "listHosts",
      api.listHosts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.hosts().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.codestarconnections.model.Host.wrap(item))
      .provideEnvironment(r)
    def listHostsPaginated(request: ListHostsRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest,
        ListHostsResponse
      ]("listHosts", api.listHosts)(request.buildAwsValue())
        .map(zio.aws.codestarconnections.model.ListHostsResponse.wrap)
        .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def getConnection(request: GetConnectionRequest): IO[
      AwsError,
      zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarconnections.model.GetConnectionRequest,
      GetConnectionResponse
    ]("getConnection", api.getConnection)(request.buildAwsValue())
      .map(zio.aws.codestarconnections.model.GetConnectionResponse.wrap)
      .provideEnvironment(r)
  }
  def createConnection(request: CreateConnectionRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.CreateConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnection(request))
  def deleteHost(request: DeleteHostRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.DeleteHostResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteHost(request))
  def updateHost(request: UpdateHostRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.UpdateHostResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateHost(request))
  def listConnections(request: ListConnectionsRequest): ZStream[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.Connection.ReadOnly
  ] = ZStream.serviceWithStream(_.listConnections(request))
  def listConnectionsPaginated(request: ListConnectionsRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.ListConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConnectionsPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createHost(request: CreateHostRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.CreateHostResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHost(request))
  def getHost(request: GetHostRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.GetHostResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHost(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteConnection(request: DeleteConnectionRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.DeleteConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnection(request))
  def listHosts(request: ListHostsRequest): ZStream[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.Host.ReadOnly
  ] = ZStream.serviceWithStream(_.listHosts(request))
  def listHostsPaginated(
      request: ListHostsRequest
  ): ZIO[zio.aws.codestarconnections.CodeStarConnections, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listHostsPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getConnection(request: GetConnectionRequest): ZIO[
    zio.aws.codestarconnections.CodeStarConnections,
    AwsError,
    zio.aws.codestarconnections.model.GetConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConnection(request))
}
