package zio.aws.codestarconnections.model
import java.lang.Integer
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.{NextToken, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListHostsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest = {
    import ListHostsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.ListHostsRequest.ReadOnly =
    zio.aws.codestarconnections.model.ListHostsRequest.wrap(buildAwsValue())
}
object ListHostsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.ListHostsRequest =
      zio.aws.codestarconnections.model.ListHostsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest
  ) extends zio.aws.codestarconnections.model.ListHostsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest
  ): zio.aws.codestarconnections.model.ListHostsRequest.ReadOnly = new Wrapper(
    impl
  )
}
