package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListHostsResponse(
    hosts: Option[Iterable[zio.aws.codestarconnections.model.Host]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse = {
    import ListHostsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse
      .builder()
      .optionallyWith(
        hosts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hosts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.ListHostsResponse.ReadOnly =
    zio.aws.codestarconnections.model.ListHostsResponse.wrap(buildAwsValue())
}
object ListHostsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.ListHostsResponse =
      zio.aws.codestarconnections.model.ListHostsResponse(
        hosts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def hosts: Option[List[zio.aws.codestarconnections.model.Host.ReadOnly]]
    def nextToken: Option[NextToken]
    def getHosts: ZIO[Any, AwsError, List[
      zio.aws.codestarconnections.model.Host.ReadOnly
    ]] = AwsError.unwrapOptionField("hosts", hosts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse
  ) extends zio.aws.codestarconnections.model.ListHostsResponse.ReadOnly {
    override val hosts
        : Option[List[zio.aws.codestarconnections.model.Host.ReadOnly]] = scala
      .Option(impl.hosts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarconnections.model.Host.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse
  ): zio.aws.codestarconnections.model.ListHostsResponse.ReadOnly = new Wrapper(
    impl
  )
}
