package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.{
  HostArn,
  HostStatus,
  HostName,
  Url,
  HostStatusMessage
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Host(
    name: Option[HostName] = None,
    hostArn: Option[HostArn] = None,
    providerType: Option[zio.aws.codestarconnections.model.ProviderType] = None,
    providerEndpoint: Option[Url] = None,
    vpcConfiguration: Option[
      zio.aws.codestarconnections.model.VpcConfiguration
    ] = None,
    status: Option[HostStatus] = None,
    statusMessage: Option[HostStatusMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.Host = {
    import Host.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.Host
      .builder()
      .optionallyWith(
        name.map(value => HostName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        hostArn.map(value => HostArn.unwrap(value): java.lang.String)
      )(_.hostArn)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(
        providerEndpoint.map(value => Url.unwrap(value): java.lang.String)
      )(_.providerEndpoint)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        status.map(value => HostStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          HostStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.Host.ReadOnly =
    zio.aws.codestarconnections.model.Host.wrap(buildAwsValue())
}
object Host {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.Host
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.Host =
      zio.aws.codestarconnections.model.Host(
        name.map(value => value),
        hostArn.map(value => value),
        providerType.map(value => value),
        providerEndpoint.map(value => value),
        vpcConfiguration.map(value => value.asEditable),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def name: Option[HostName]
    def hostArn: Option[HostArn]
    def providerType: Option[zio.aws.codestarconnections.model.ProviderType]
    def providerEndpoint: Option[Url]
    def vpcConfiguration
        : Option[zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly]
    def status: Option[HostStatus]
    def statusMessage: Option[HostStatusMessage]
    def getName: ZIO[Any, AwsError, HostName] =
      AwsError.unwrapOptionField("name", name)
    def getHostArn: ZIO[Any, AwsError, HostArn] =
      AwsError.unwrapOptionField("hostArn", hostArn)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codestarconnections.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getProviderEndpoint: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("providerEndpoint", providerEndpoint)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getStatus: ZIO[Any, AwsError, HostStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, HostStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.Host
  ) extends zio.aws.codestarconnections.model.Host.ReadOnly {
    override val name: Option[HostName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.HostName(value)
      )
    override val hostArn: Option[HostArn] = scala
      .Option(impl.hostArn())
      .map(value => zio.aws.codestarconnections.model.primitives.HostArn(value))
    override val providerType
        : Option[zio.aws.codestarconnections.model.ProviderType] = scala
      .Option(impl.providerType())
      .map(value => zio.aws.codestarconnections.model.ProviderType.wrap(value))
    override val providerEndpoint: Option[Url] = scala
      .Option(impl.providerEndpoint())
      .map(value => zio.aws.codestarconnections.model.primitives.Url(value))
    override val vpcConfiguration
        : Option[zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly] =
      scala
        .Option(impl.vpcConfiguration())
        .map(value =>
          zio.aws.codestarconnections.model.VpcConfiguration.wrap(value)
        )
    override val status: Option[HostStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.HostStatus(value)
      )
    override val statusMessage: Option[HostStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.HostStatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.Host
  ): zio.aws.codestarconnections.model.Host.ReadOnly = new Wrapper(impl)
}
