package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.ConnectionArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateConnectionResponse(
    connectionArn: ConnectionArn,
    tags: Option[Iterable[zio.aws.codestarconnections.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.CreateConnectionResponse = {
    import CreateConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.CreateConnectionResponse
      .builder()
      .connectionArn(ConnectionArn.unwrap(connectionArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.CreateConnectionResponse.ReadOnly =
    zio.aws.codestarconnections.model.CreateConnectionResponse
      .wrap(buildAwsValue())
}
object CreateConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.CreateConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.CreateConnectionResponse =
      zio.aws.codestarconnections.model.CreateConnectionResponse(
        connectionArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionArn: ConnectionArn
    def tags: Option[List[zio.aws.codestarconnections.model.Tag.ReadOnly]]
    def getConnectionArn: ZIO[Any, Nothing, ConnectionArn] =
      ZIO.succeed(connectionArn)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.codestarconnections.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.CreateConnectionResponse
  ) extends zio.aws.codestarconnections.model.CreateConnectionResponse.ReadOnly {
    override val connectionArn: ConnectionArn =
      zio.aws.codestarconnections.model.primitives
        .ConnectionArn(impl.connectionArn())
    override val tags
        : Option[List[zio.aws.codestarconnections.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarconnections.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.CreateConnectionResponse
  ): zio.aws.codestarconnections.model.CreateConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
