package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.ConnectionArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConnectionRequest(connectionArn: ConnectionArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.DeleteConnectionRequest = {
    import DeleteConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.DeleteConnectionRequest
      .builder()
      .connectionArn(ConnectionArn.unwrap(connectionArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.DeleteConnectionRequest.ReadOnly =
    zio.aws.codestarconnections.model.DeleteConnectionRequest
      .wrap(buildAwsValue())
}
object DeleteConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.DeleteConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.DeleteConnectionRequest =
      zio.aws.codestarconnections.model.DeleteConnectionRequest(connectionArn)
    def connectionArn: ConnectionArn
    def getConnectionArn: ZIO[Any, Nothing, ConnectionArn] =
      ZIO.succeed(connectionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.DeleteConnectionRequest
  ) extends zio.aws.codestarconnections.model.DeleteConnectionRequest.ReadOnly {
    override val connectionArn: ConnectionArn =
      zio.aws.codestarconnections.model.primitives
        .ConnectionArn(impl.connectionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.DeleteConnectionRequest
  ): zio.aws.codestarconnections.model.DeleteConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
