package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.{Url, HostStatus, HostName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetHostResponse(
    name: Optional[HostName] = Optional.Absent,
    status: Optional[HostStatus] = Optional.Absent,
    providerType: Optional[zio.aws.codestarconnections.model.ProviderType] =
      Optional.Absent,
    providerEndpoint: Optional[Url] = Optional.Absent,
    vpcConfiguration: Optional[
      zio.aws.codestarconnections.model.VpcConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.GetHostResponse = {
    import GetHostResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.GetHostResponse
      .builder()
      .optionallyWith(
        name.map(value => HostName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        status.map(value => HostStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(
        providerEndpoint.map(value => Url.unwrap(value): java.lang.String)
      )(_.providerEndpoint)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.GetHostResponse.ReadOnly =
    zio.aws.codestarconnections.model.GetHostResponse.wrap(buildAwsValue())
}
object GetHostResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.GetHostResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.GetHostResponse =
      zio.aws.codestarconnections.model.GetHostResponse(
        name.map(value => value),
        status.map(value => value),
        providerType.map(value => value),
        providerEndpoint.map(value => value),
        vpcConfiguration.map(value => value.asEditable)
      )
    def name: Optional[HostName]
    def status: Optional[HostStatus]
    def providerType: Optional[zio.aws.codestarconnections.model.ProviderType]
    def providerEndpoint: Optional[Url]
    def vpcConfiguration
        : Optional[zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly]
    def getName: ZIO[Any, AwsError, HostName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, HostStatus] =
      AwsError.unwrapOptionField("status", status)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codestarconnections.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getProviderEndpoint: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("providerEndpoint", providerEndpoint)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.GetHostResponse
  ) extends zio.aws.codestarconnections.model.GetHostResponse.ReadOnly {
    override val name: Optional[HostName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.HostName(value)
      )
    override val status: Optional[HostStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.HostStatus(value)
      )
    override val providerType
        : Optional[zio.aws.codestarconnections.model.ProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerType())
        .map(value =>
          zio.aws.codestarconnections.model.ProviderType.wrap(value)
        )
    override val providerEndpoint: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.providerEndpoint())
      .map(value => zio.aws.codestarconnections.model.primitives.Url(value))
    override val vpcConfiguration: Optional[
      zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConfiguration())
      .map(value =>
        zio.aws.codestarconnections.model.VpcConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.GetHostResponse
  ): zio.aws.codestarconnections.model.GetHostResponse.ReadOnly = new Wrapper(
    impl
  )
}
