package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.{Url, HostName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateHostRequest(
    name: HostName,
    providerType: zio.aws.codestarconnections.model.ProviderType,
    providerEndpoint: Url,
    vpcConfiguration: Optional[
      zio.aws.codestarconnections.model.VpcConfiguration
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.codestarconnections.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.CreateHostRequest = {
    import CreateHostRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.CreateHostRequest
      .builder()
      .name(HostName.unwrap(name): java.lang.String)
      .providerType(providerType.unwrap)
      .providerEndpoint(Url.unwrap(providerEndpoint): java.lang.String)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.CreateHostRequest.ReadOnly =
    zio.aws.codestarconnections.model.CreateHostRequest.wrap(buildAwsValue())
}
object CreateHostRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.CreateHostRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.CreateHostRequest =
      zio.aws.codestarconnections.model.CreateHostRequest(
        name,
        providerType,
        providerEndpoint,
        vpcConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: HostName
    def providerType: zio.aws.codestarconnections.model.ProviderType
    def providerEndpoint: Url
    def vpcConfiguration
        : Optional[zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly]
    def tags: Optional[List[zio.aws.codestarconnections.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, HostName] = ZIO.succeed(name)
    def getProviderType
        : ZIO[Any, Nothing, zio.aws.codestarconnections.model.ProviderType] =
      ZIO.succeed(providerType)
    def getProviderEndpoint: ZIO[Any, Nothing, Url] =
      ZIO.succeed(providerEndpoint)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.codestarconnections.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.CreateHostRequest
  ) extends zio.aws.codestarconnections.model.CreateHostRequest.ReadOnly {
    override val name: HostName =
      zio.aws.codestarconnections.model.primitives.HostName(impl.name())
    override val providerType: zio.aws.codestarconnections.model.ProviderType =
      zio.aws.codestarconnections.model.ProviderType.wrap(impl.providerType())
    override val providerEndpoint: Url =
      zio.aws.codestarconnections.model.primitives.Url(impl.providerEndpoint())
    override val vpcConfiguration: Optional[
      zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConfiguration())
      .map(value =>
        zio.aws.codestarconnections.model.VpcConfiguration.wrap(value)
      )
    override val tags
        : Optional[List[zio.aws.codestarconnections.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codestarconnections.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.CreateHostRequest
  ): zio.aws.codestarconnections.model.CreateHostRequest.ReadOnly = new Wrapper(
    impl
  )
}
