package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.{
  HostArn,
  HostStatus,
  HostName,
  Url,
  HostStatusMessage
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Host(
    name: Optional[HostName] = Optional.Absent,
    hostArn: Optional[HostArn] = Optional.Absent,
    providerType: Optional[zio.aws.codestarconnections.model.ProviderType] =
      Optional.Absent,
    providerEndpoint: Optional[Url] = Optional.Absent,
    vpcConfiguration: Optional[
      zio.aws.codestarconnections.model.VpcConfiguration
    ] = Optional.Absent,
    status: Optional[HostStatus] = Optional.Absent,
    statusMessage: Optional[HostStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.Host = {
    import Host.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.Host
      .builder()
      .optionallyWith(
        name.map(value => HostName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        hostArn.map(value => HostArn.unwrap(value): java.lang.String)
      )(_.hostArn)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(
        providerEndpoint.map(value => Url.unwrap(value): java.lang.String)
      )(_.providerEndpoint)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        status.map(value => HostStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          HostStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.Host.ReadOnly =
    zio.aws.codestarconnections.model.Host.wrap(buildAwsValue())
}
object Host {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.Host
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.Host =
      zio.aws.codestarconnections.model.Host(
        name.map(value => value),
        hostArn.map(value => value),
        providerType.map(value => value),
        providerEndpoint.map(value => value),
        vpcConfiguration.map(value => value.asEditable),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def name: Optional[HostName]
    def hostArn: Optional[HostArn]
    def providerType: Optional[zio.aws.codestarconnections.model.ProviderType]
    def providerEndpoint: Optional[Url]
    def vpcConfiguration
        : Optional[zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly]
    def status: Optional[HostStatus]
    def statusMessage: Optional[HostStatusMessage]
    def getName: ZIO[Any, AwsError, HostName] =
      AwsError.unwrapOptionField("name", name)
    def getHostArn: ZIO[Any, AwsError, HostArn] =
      AwsError.unwrapOptionField("hostArn", hostArn)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codestarconnections.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getProviderEndpoint: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("providerEndpoint", providerEndpoint)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getStatus: ZIO[Any, AwsError, HostStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, HostStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.Host
  ) extends zio.aws.codestarconnections.model.Host.ReadOnly {
    override val name: Optional[HostName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.HostName(value)
      )
    override val hostArn: Optional[HostArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hostArn())
      .map(value => zio.aws.codestarconnections.model.primitives.HostArn(value))
    override val providerType
        : Optional[zio.aws.codestarconnections.model.ProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerType())
        .map(value =>
          zio.aws.codestarconnections.model.ProviderType.wrap(value)
        )
    override val providerEndpoint: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.providerEndpoint())
      .map(value => zio.aws.codestarconnections.model.primitives.Url(value))
    override val vpcConfiguration: Optional[
      zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConfiguration())
      .map(value =>
        zio.aws.codestarconnections.model.VpcConfiguration.wrap(value)
      )
    override val status: Optional[HostStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.HostStatus(value)
      )
    override val statusMessage: Optional[HostStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.codestarconnections.model.primitives.HostStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.Host
  ): zio.aws.codestarconnections.model.Host.ReadOnly = new Wrapper(impl)
}
