package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.{Url, HostArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateHostRequest(
    hostArn: HostArn,
    providerEndpoint: Option[Url] = None,
    vpcConfiguration: Option[
      zio.aws.codestarconnections.model.VpcConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.UpdateHostRequest = {
    import UpdateHostRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.UpdateHostRequest
      .builder()
      .hostArn(HostArn.unwrap(hostArn): java.lang.String)
      .optionallyWith(
        providerEndpoint.map(value => Url.unwrap(value): java.lang.String)
      )(_.providerEndpoint)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.UpdateHostRequest.ReadOnly =
    zio.aws.codestarconnections.model.UpdateHostRequest.wrap(buildAwsValue())
}
object UpdateHostRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.UpdateHostRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.UpdateHostRequest =
      zio.aws.codestarconnections.model.UpdateHostRequest(
        hostArn,
        providerEndpoint.map(value => value),
        vpcConfiguration.map(value => value.asEditable)
      )
    def hostArn: HostArn
    def providerEndpoint: Option[Url]
    def vpcConfiguration
        : Option[zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly]
    def getHostArn: ZIO[Any, Nothing, HostArn] = ZIO.succeed(hostArn)
    def getProviderEndpoint: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("providerEndpoint", providerEndpoint)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.UpdateHostRequest
  ) extends zio.aws.codestarconnections.model.UpdateHostRequest.ReadOnly {
    override val hostArn: HostArn =
      zio.aws.codestarconnections.model.primitives.HostArn(impl.hostArn())
    override val providerEndpoint: Option[Url] = scala
      .Option(impl.providerEndpoint())
      .map(value => zio.aws.codestarconnections.model.primitives.Url(value))
    override val vpcConfiguration
        : Option[zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly] =
      scala
        .Option(impl.vpcConfiguration())
        .map(value =>
          zio.aws.codestarconnections.model.VpcConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.UpdateHostRequest
  ): zio.aws.codestarconnections.model.UpdateHostRequest.ReadOnly = new Wrapper(
    impl
  )
}
