package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.HostArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetHostRequest(hostArn: HostArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.GetHostRequest = {
    import GetHostRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.GetHostRequest
      .builder()
      .hostArn(HostArn.unwrap(hostArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.GetHostRequest.ReadOnly =
    zio.aws.codestarconnections.model.GetHostRequest.wrap(buildAwsValue())
}
object GetHostRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.GetHostRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.GetHostRequest =
      zio.aws.codestarconnections.model.GetHostRequest(hostArn)
    def hostArn: HostArn
    def getHostArn: ZIO[Any, Nothing, HostArn] = ZIO.succeed(hostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.GetHostRequest
  ) extends zio.aws.codestarconnections.model.GetHostRequest.ReadOnly {
    override val hostArn: HostArn =
      zio.aws.codestarconnections.model.primitives.HostArn(impl.hostArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.GetHostRequest
  ): zio.aws.codestarconnections.model.GetHostRequest.ReadOnly = new Wrapper(
    impl
  )
}
