package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AmazonResourceName,
    tags: Iterable[zio.aws.codestarconnections.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.TagResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.TagResourceRequest.ReadOnly =
    zio.aws.codestarconnections.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.TagResourceRequest =
      zio.aws.codestarconnections.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: AmazonResourceName
    def tags: List[zio.aws.codestarconnections.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.codestarconnections.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.TagResourceRequest
  ) extends zio.aws.codestarconnections.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.codestarconnections.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val tags: List[zio.aws.codestarconnections.model.Tag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.codestarconnections.model.Tag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.TagResourceRequest
  ): zio.aws.codestarconnections.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
