package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.ConnectionArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetConnectionRequest(connectionArn: ConnectionArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.GetConnectionRequest = {
    import GetConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.GetConnectionRequest
      .builder()
      .connectionArn(ConnectionArn.unwrap(connectionArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.GetConnectionRequest.ReadOnly =
    zio.aws.codestarconnections.model.GetConnectionRequest.wrap(buildAwsValue())
}
object GetConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.GetConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.GetConnectionRequest =
      zio.aws.codestarconnections.model.GetConnectionRequest(connectionArn)
    def connectionArn: ConnectionArn
    def getConnectionArn: ZIO[Any, Nothing, ConnectionArn] =
      ZIO.succeed(connectionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.GetConnectionRequest
  ) extends zio.aws.codestarconnections.model.GetConnectionRequest.ReadOnly {
    override val connectionArn: ConnectionArn =
      zio.aws.codestarconnections.model.primitives
        .ConnectionArn(impl.connectionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.GetConnectionRequest
  ): zio.aws.codestarconnections.model.GetConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
