package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.{
  TlsCertificate,
  SecurityGroupId,
  SubnetId,
  VpcId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcConfiguration(
    vpcId: VpcId,
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Iterable[SecurityGroupId],
    tlsCertificate: Option[TlsCertificate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.VpcConfiguration = {
    import VpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.VpcConfiguration
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tlsCertificate.map(value =>
          TlsCertificate.unwrap(value): java.lang.String
        )
      )(_.tlsCertificate)
      .build()
  }
  def asReadOnly: zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly =
    zio.aws.codestarconnections.model.VpcConfiguration.wrap(buildAwsValue())
}
object VpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.VpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.VpcConfiguration =
      zio.aws.codestarconnections.model.VpcConfiguration(
        vpcId,
        subnetIds,
        securityGroupIds,
        tlsCertificate.map(value => value)
      )
    def vpcId: VpcId
    def subnetIds: List[SubnetId]
    def securityGroupIds: List[SecurityGroupId]
    def tlsCertificate: Option[TlsCertificate]
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getTlsCertificate: ZIO[Any, AwsError, TlsCertificate] =
      AwsError.unwrapOptionField("tlsCertificate", tlsCertificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.VpcConfiguration
  ) extends zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly {
    override val vpcId: VpcId =
      zio.aws.codestarconnections.model.primitives.VpcId(impl.vpcId())
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.codestarconnections.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.codestarconnections.model.primitives.SecurityGroupId(item)
      }
      .toList
    override val tlsCertificate: Option[TlsCertificate] = scala
      .Option(impl.tlsCertificate())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.TlsCertificate(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.VpcConfiguration
  ): zio.aws.codestarconnections.model.VpcConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
