package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListConnectionsResponse(
    connections: Option[
      Iterable[zio.aws.codestarconnections.model.Connection]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.ListConnectionsResponse = {
    import ListConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.ListConnectionsResponse
      .builder()
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.ListConnectionsResponse.ReadOnly =
    zio.aws.codestarconnections.model.ListConnectionsResponse
      .wrap(buildAwsValue())
}
object ListConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.ListConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarconnections.model.ListConnectionsResponse =
      zio.aws.codestarconnections.model.ListConnectionsResponse(
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connections
        : Option[List[zio.aws.codestarconnections.model.Connection.ReadOnly]]
    def nextToken: Option[NextToken]
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.codestarconnections.model.Connection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListConnectionsResponse
  ) extends zio.aws.codestarconnections.model.ListConnectionsResponse.ReadOnly {
    override val connections
        : Option[List[zio.aws.codestarconnections.model.Connection.ReadOnly]] =
      scala
        .Option(impl.connections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codestarconnections.model.Connection.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codestarconnections.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListConnectionsResponse
  ): zio.aws.codestarconnections.model.ListConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
