package zio.aws.codestarconnections.model
import scala.jdk.CollectionConverters._
sealed trait ProviderType {
  def unwrap
      : software.amazon.awssdk.services.codestarconnections.model.ProviderType
}
object ProviderType {
  def wrap(
      value: software.amazon.awssdk.services.codestarconnections.model.ProviderType
  ): zio.aws.codestarconnections.model.ProviderType = value match {
    case software.amazon.awssdk.services.codestarconnections.model.ProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codestarconnections.model.ProviderType.BITBUCKET =>
      val r = Bitbucket
      r
    case software.amazon.awssdk.services.codestarconnections.model.ProviderType.GIT_HUB =>
      val r = GitHub
      r
    case software.amazon.awssdk.services.codestarconnections.model.ProviderType.GIT_HUB_ENTERPRISE_SERVER =>
      val r = GitHubEnterpriseServer
      r
    case software.amazon.awssdk.services.codestarconnections.model.ProviderType.GIT_LAB =>
      val r = GitLab
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codestarconnections.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codestarconnections.model.ProviderType =
      software.amazon.awssdk.services.codestarconnections.model.ProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object Bitbucket extends zio.aws.codestarconnections.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codestarconnections.model.ProviderType =
      software.amazon.awssdk.services.codestarconnections.model.ProviderType.BITBUCKET
  }
  case object GitHub extends zio.aws.codestarconnections.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codestarconnections.model.ProviderType =
      software.amazon.awssdk.services.codestarconnections.model.ProviderType.GIT_HUB
  }
  case object GitHubEnterpriseServer
      extends zio.aws.codestarconnections.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codestarconnections.model.ProviderType =
      software.amazon.awssdk.services.codestarconnections.model.ProviderType.GIT_HUB_ENTERPRISE_SERVER
  }
  case object GitLab extends zio.aws.codestarconnections.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codestarconnections.model.ProviderType =
      software.amazon.awssdk.services.codestarconnections.model.ProviderType.GIT_LAB
  }
}
