package zio.aws.codestarconnections.model
import zio.ZIO
import zio.aws.codestarconnections.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarconnections.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarconnections.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarconnections.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.codestarconnections.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarconnections.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarconnections.model.ListTagsForResourceRequest =
      zio.aws.codestarconnections.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: AmazonResourceName
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListTagsForResourceRequest
  ) extends zio.aws.codestarconnections.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.codestarconnections.model.primitives
        .AmazonResourceName(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarconnections.model.ListTagsForResourceRequest
  ): zio.aws.codestarconnections.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
