package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{
  RepositoryEnableIssues,
  RepositoryOwner,
  GitHubPersonalToken,
  RepositoryDescription,
  RepositoryName,
  RepositoryType,
  RepositoryIsPrivate
}
import scala.jdk.CollectionConverters.*
final case class GitHubCodeDestination(
    name: RepositoryName,
    description: Optional[RepositoryDescription] = Optional.Absent,
    `type`: RepositoryType,
    owner: RepositoryOwner,
    privateRepository: RepositoryIsPrivate,
    issuesEnabled: RepositoryEnableIssues,
    token: GitHubPersonalToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.GitHubCodeDestination = {
    import GitHubCodeDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.GitHubCodeDestination
      .builder()
      .name(RepositoryName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          RepositoryDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .`type`(RepositoryType.unwrap(`type`): java.lang.String)
      .owner(RepositoryOwner.unwrap(owner): java.lang.String)
      .privateRepository(
        RepositoryIsPrivate.unwrap(privateRepository): java.lang.Boolean
      )
      .issuesEnabled(
        RepositoryEnableIssues.unwrap(issuesEnabled): java.lang.Boolean
      )
      .token(GitHubPersonalToken.unwrap(token): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.GitHubCodeDestination.ReadOnly =
    zio.aws.codestar.model.GitHubCodeDestination.wrap(buildAwsValue())
}
object GitHubCodeDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.GitHubCodeDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.GitHubCodeDestination =
      zio.aws.codestar.model.GitHubCodeDestination(
        name,
        description.map(value => value),
        `type`,
        owner,
        privateRepository,
        issuesEnabled,
        token
      )
    def name: RepositoryName
    def description: Optional[RepositoryDescription]
    def `type`: RepositoryType
    def owner: RepositoryOwner
    def privateRepository: RepositoryIsPrivate
    def issuesEnabled: RepositoryEnableIssues
    def token: GitHubPersonalToken
    def getName: ZIO[Any, Nothing, RepositoryName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, RepositoryDescription] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, Nothing, RepositoryType] = ZIO.succeed(`type`)
    def getOwner: ZIO[Any, Nothing, RepositoryOwner] = ZIO.succeed(owner)
    def getPrivateRepository: ZIO[Any, Nothing, RepositoryIsPrivate] =
      ZIO.succeed(privateRepository)
    def getIssuesEnabled: ZIO[Any, Nothing, RepositoryEnableIssues] =
      ZIO.succeed(issuesEnabled)
    def getToken: ZIO[Any, Nothing, GitHubPersonalToken] = ZIO.succeed(token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.GitHubCodeDestination
  ) extends zio.aws.codestar.model.GitHubCodeDestination.ReadOnly {
    override val name: RepositoryName =
      zio.aws.codestar.model.primitives.RepositoryName(impl.name())
    override val description: Optional[RepositoryDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codestar.model.primitives.RepositoryDescription(value)
        )
    override val `type`: RepositoryType =
      zio.aws.codestar.model.primitives.RepositoryType(impl.`type`())
    override val owner: RepositoryOwner =
      zio.aws.codestar.model.primitives.RepositoryOwner(impl.owner())
    override val privateRepository: RepositoryIsPrivate =
      zio.aws.codestar.model.primitives
        .RepositoryIsPrivate(impl.privateRepository())
    override val issuesEnabled: RepositoryEnableIssues =
      zio.aws.codestar.model.primitives
        .RepositoryEnableIssues(impl.issuesEnabled())
    override val token: GitHubPersonalToken =
      zio.aws.codestar.model.primitives.GitHubPersonalToken(impl.token())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.GitHubCodeDestination
  ): zio.aws.codestar.model.GitHubCodeDestination.ReadOnly = new Wrapper(impl)
}
